<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\AdvertisementController;
use App\Http\Controllers\ReceiptController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

// Public routes
Route::post('/auth/login', [AuthController::class, 'login']);
Route::get('/auth/me', [AuthController::class, 'me'])->middleware('auth:sanctum');
Route::post('/auth/logout', [AuthController::class, 'logout'])->middleware('auth:sanctum');

// Protected routes
Route::middleware('auth:sanctum')->group(function () {
    // Advertisements
    Route::get('/advertisements', [AdvertisementController::class, 'index']);
    Route::get('/advertisements/{id}', [AdvertisementController::class, 'show']);
    Route::post('/advertisements', [AdvertisementController::class, 'store']);

    // Receipts
    Route::get('/receipts/advertisement/{advertisementId}', [ReceiptController::class, 'getByAdvertisement']);
    Route::post('/receipts', [ReceiptController::class, 'store']);

    // Reports
    Route::get('/reports', [ReportController::class, 'index']);
    Route::get('/reports/date-range', [ReportController::class, 'getByDateRange']);
    Route::post('/reports', [ReportController::class, 'store']);

    // Users (Admin only)
    Route::get('/users', [UserController::class, 'index']);
    Route::post('/users', [UserController::class, 'store']);
    Route::put('/users/{id}', [UserController::class, 'update']);
    Route::put('/users/{id}/password', [UserController::class, 'updatePassword']);
    Route::delete('/users/{id}', [UserController::class, 'destroy']);

    // Change own password
    Route::post('/users/change-password', [UserController::class, 'changeMyPassword']);
});


