import { Toaster } from "@/components/ui/sonner";
import { TooltipProvider } from "@/components/ui/tooltip";
import NotFound from "@/pages/NotFound";
import { Route, Switch } from "wouter";
import ErrorBoundary from "./components/ErrorBoundary";
import { ThemeProvider } from "./contexts/ThemeContext";
import Home from "./pages/Home";
import Login from "./pages/Login";
import CreateAdvertisement from "./pages/CreateAdvertisement";
import AdvertisementDetail from "./pages/AdvertisementDetail";
import ReceiptView from "./pages/ReceiptView";
import Reports from "./pages/Reports";
import Users from "./pages/Users";
import ChangePassword from "./pages/ChangePassword";

function Router() {
  return (
    <Switch>
      <Route path={"/login"} component={Login} />
      <Route path={"/"} component={Home} />
      <Route path={"/advertisements/create"} component={CreateAdvertisement} />
      <Route path={"/advertisements/:id"}>
        {(params) => <AdvertisementDetail id={parseInt(params.id)} />}
      </Route>
      <Route path={"/receipts/:id"}>
        {(params) => <ReceiptView advertisementId={parseInt(params.id)} />}
      </Route>
      <Route path={"/reports"} component={Reports} />
      <Route path={"/users"} component={Users} />
      <Route path={"/change-password"} component={ChangePassword} />
      <Route path={"/404"} component={NotFound} />
      <Route component={NotFound} />
    </Switch>
  );
}

function App() {
  return (
    <ErrorBoundary>
      <ThemeProvider defaultTheme="light">
        <TooltipProvider>
          <Toaster />
          <Router />
        </TooltipProvider>
      </ThemeProvider>
    </ErrorBoundary>
  );
}

export default App;


