<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('advertisements', function (Blueprint $table) {
            $table->id();
            $table->string('receipt_number', 20)->unique();
            $table->string('issue_date', 10);
            $table->text('advertiser_name');
            $table->text('amount_in_words');
            $table->integer('amount_in_numbers');
            $table->integer('number_of_times');
            $table->text('subject');
            $table->string('order_number', 50)->nullable();
            $table->text('signature_location')->nullable();
            $table->enum('payment_method', ['نقدی', 'چک', 'رسید']);
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('advertisements');
    }
};


