<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Advertisement extends Model
{
    use HasFactory;

    protected $fillable = [
        'receipt_number',
        'issue_date',
        'advertiser_name',
        'amount_in_words',
        'amount_in_numbers',
        'number_of_times',
        'subject',
        'order_number',
        'signature_location',
        'payment_method',
        'user_id',
    ];

    protected $casts = [
        'amount_in_numbers' => 'integer',
        'number_of_times' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function printDates(): HasMany
    {
        return $this->hasMany(PrintDate::class, 'advertisement_id');
    }

    public function receipts(): HasMany
    {
        return $this->hasMany(Receipt::class, 'advertisement_id');
    }
}


