<?php

namespace App\Http\Controllers;

use App\Models\Report;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:sanctum');
    }

    public function index()
    {
        $reports = Report::where('user_id', Auth::id())
            ->orderBy('created_at', 'desc')
            ->get();

        return response()->json($reports);
    }

    public function getByDateRange(Request $request)
    {
        $validated = $request->validate([
            'start_date' => 'required|string',
            'end_date' => 'required|string',
        ]);

        $reports = Report::where('user_id', Auth::id())
            ->whereBetween('report_date', [$validated['start_date'], $validated['end_date']])
            ->orderBy('report_date', 'desc')
            ->get();

        return response()->json($reports);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'report_type' => 'required|in:daily,monthly,yearly',
            'report_date' => 'required|string',
            'total_amount' => 'required|integer|min:0',
            'advertisement_count' => 'required|integer|min:0',
            'report_content' => 'required|string',
            'pdf_url' => 'nullable|string|max:500',
        ]);

        $report = Report::create([
            ...$validated,
            'user_id' => Auth::id(),
        ]);

        return response()->json($report, 201);
    }
}


