# Khabar Ads Manager - Laravel Version

این پروژه نسخه Laravel از سیستم مدیریت آگهی روزنامه خبر جنوب است که از Node.js/Express به Laravel تبدیل شده است.

## 📋 فهرست مطالب

- [نصب و راه‌اندازی](#نصب-و-راه‌اندازی)
- [ساختار پروژه](#ساختار-پروژه)
- [API Endpoints](#api-endpoints)
- [تغییرات از نسخه Node.js](#تغییرات-از-نسخه-nodejs)
- [راهنمای تبدیل Frontend](#راهنمای-تبدیل-frontend)

## 🚀 نصب و راه‌اندازی

### پیش‌نیازها

- PHP >= 8.2
- Composer
- MySQL >= 5.7
- Node.js و npm

### مراحل نصب

1. **نصب وابستگی‌ها**

```bash
cd laravel-app
composer install
npm install
```

2. **تنظیمات محیط**

```bash
cp .env.example .env
php artisan key:generate
```

فایل `.env` را ویرایش کنید:

```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=khabar_ads
DB_USERNAME=root
DB_PASSWORD=your_password
```

3. **اجرای Migrations**

```bash
php artisan migrate
php artisan db:seed
```

این دستورات:
- جداول دیتابیس را ایجاد می‌کند
- کاربر admin را ایجاد می‌کند (username: `admin`, password: `admin123`)

4. **Build Frontend**

```bash
npm run build
```

5. **اجرای سرور**

```bash
php artisan serve
```

سرور در آدرس `http://localhost:8000` اجرا می‌شود.

## 📁 ساختار پروژه

```
laravel-app/
├── app/
│   ├── Http/
│   │   ├── Controllers/     # Controllers برای API
│   │   └── Middleware/      # Middleware ها
│   ├── Models/              # Eloquent Models
│   ├── Helpers/             # Helper functions (JalaliHelper)
│   └── Policies/            # Authorization policies
├── database/
│   ├── migrations/          # Database migrations
│   └── seeders/             # Database seeders
├── routes/
│   ├── api.php              # API routes
│   └── web.php              # Web routes
├── resources/
│   ├── js/                  # React components
│   └── views/               # Blade templates
└── public/                  # Public files
```

## 🔌 API Endpoints

### Authentication
- `POST /api/auth/login` - ورود
- `GET /api/auth/me` - اطلاعات کاربر فعلی
- `POST /api/auth/logout` - خروج

### Advertisements
- `GET /api/advertisements` - لیست آگهی‌ها
- `GET /api/advertisements/{id}` - جزئیات آگهی
- `POST /api/advertisements` - ایجاد آگهی جدید

### Receipts
- `GET /api/receipts/advertisement/{advertisementId}` - دریافت قبض
- `POST /api/receipts` - ایجاد قبض

### Reports
- `GET /api/reports` - لیست گزارش‌ها
- `GET /api/reports/date-range` - گزارش بر اساس بازه تاریخ
- `POST /api/reports` - ایجاد گزارش

### Users (Admin only)
- `GET /api/users` - لیست کاربران
- `POST /api/users` - ایجاد کاربر جدید
- `PUT /api/users/{id}` - به‌روزرسانی کاربر
- `PUT /api/users/{id}/password` - تغییر رمز عبور
- `DELETE /api/users/{id}` - حذف کاربر
- `POST /api/users/change-password` - تغییر رمز عبور خود

## 🔄 تغییرات از نسخه Node.js

### Backend
- **قبل**: Node.js + Express + tRPC + Drizzle ORM
- **بعد**: Laravel + Eloquent ORM + REST API

### Authentication
- **قبل**: JWT cookies با jose library
- **بعد**: Laravel Sanctum session-based

### Database
- **قبل**: Drizzle ORM با TypeScript
- **بعد**: Eloquent ORM با PHP

### API
- **قبل**: tRPC type-safe endpoints
- **بعد**: REST API با Laravel

## 📝 راهنمای تبدیل Frontend

برای تبدیل Frontend از tRPC به Laravel API، فایل `FRONTEND_MIGRATION.md` را مطالعه کنید.

خلاصه تغییرات:
1. حذف tRPC و استفاده از axios/fetch
2. تبدیل تمام API calls طبق راهنمای FRONTEND_MIGRATION.md
3. به‌روزرسانی useAuth hook
4. Error handling برای Laravel response format

## 📚 فایل‌های راهنما

- `DEPLOYMENT.md` - راهنمای کامل نصب و deployment
- `FRONTEND_MIGRATION.md` - راهنمای تبدیل Frontend
- `SUMMARY.md` - خلاصه تغییرات و کارهای انجام شده

## 🔐 Authentication

سیستم از Laravel Sanctum برای session-based authentication استفاده می‌کند.

- تمام درخواست‌های API باید با `withCredentials: true` ارسال شوند
- Cookie session به صورت خودکار مدیریت می‌شود
- برای protected routes، middleware `auth:sanctum` استفاده می‌شود

## 📅 Jalaali Calendar

برای تبدیل تاریخ شمسی/میلادی از `App\Helpers\JalaliHelper` استفاده کنید:

```php
use App\Helpers\JalaliHelper;

$jalali = JalaliHelper::gregorianToJalali('2024-01-01');
$gregorian = JalaliHelper::jalaliToGregorian('1402-10-11');
```

## 🛠️ Development

برای development:

```bash
# Backend
php artisan serve

# Frontend (در ترمینال دیگر)
npm run dev
```

## 📦 Production Build

```bash
npm run build
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

## 🐛 Troubleshooting

### خطای "Class not found"
```bash
composer dump-autoload
```

### خطای Migration
```bash
php artisan migrate:fresh
php artisan db:seed
```

### خطای Frontend
```bash
rm -rf node_modules
npm install
npm run build
```

## 📄 License

MIT
