import { Button } from "@/components/ui/button";
import { useLocation } from "wouter";

export default function NotFound() {
  const [, setLocation] = useLocation();

  return (
    <div className="min-h-screen flex items-center justify-center bg-gradient-to-br from-blue-50 to-indigo-100" dir="rtl">
      <div className="text-center">
        <h1 className="text-6xl font-bold text-indigo-600 mb-4">404</h1>
        <h2 className="text-2xl font-semibold text-gray-800 mb-4">صفحه یافت نشد</h2>
        <p className="text-gray-600 mb-8">صفحه‌ای که به دنبال آن هستید وجود ندارد.</p>
        <Button onClick={() => setLocation("/")} className="bg-indigo-600 hover:bg-indigo-700">
          بازگشت به صفحه اصلی
        </Button>
      </div>
    </div>
  );
}


