import * as jalaali from "jalaali-js";

const pad = (value: number) => String(value).padStart(2, "0");

const splitDate = (value: string) => {
  const [year, month, day] = value.split("-").map((part) => parseInt(part, 10));
  if ([year, month, day].some((part) => Number.isNaN(part))) {
    return null;
  }
  return { year, month, day };
};

export const isValidJalaliDate = (value: string) => {
  const parts = splitDate(value);
  if (!parts) return false;
  return jalaali.isValidJalaaliDate(parts.year, parts.month, parts.day);
};

export const gregorianToJalali = (value: string) => {
  if (!value) return "";
  const parts = splitDate(value);
  if (!parts) return value;

  const { jy, jm, jd } = jalaali.toJalaali(parts.year, parts.month, parts.day);
  return `${jy}-${pad(jm)}-${pad(jd)}`;
};

export const jalaliToGregorian = (value: string) => {
  if (!value) return null;
  const parts = splitDate(value);
  if (!parts) return null;

  if (!jalaali.isValidJalaaliDate(parts.year, parts.month, parts.day)) {
    return null;
  }

  const { gy, gm, gd } = jalaali.toGregorian(parts.year, parts.month, parts.day);
  return `${gy}-${pad(gm)}-${pad(gd)}`;
};

export const todayJalali = () => {
  const todayGregorian = new Date();
  const { jy, jm, jd } = jalaali.toJalaali(
    todayGregorian.getFullYear(),
    todayGregorian.getMonth() + 1,
    todayGregorian.getDate()
  );
  return `${jy}-${pad(jm)}-${pad(jd)}`;
};


