import { jalaliToGregorian, gregorianToJalali } from './jalali';

export { jalaliToGregorian, gregorianToJalali };

/**
 * فرمت‌کردن تاریخ شمسی برای نمایش
 */
export function formatJalaliDate(jalaliDate: string): string {
  try {
    const [year, month, day] = jalaliDate.split('-').map(Number);
    const persianYear = toPersianNumbers(year.toString());
    const persianMonth = toPersianNumbers(month.toString());
    const persianDay = toPersianNumbers(day.toString());
    
    return `${persianYear}/${persianMonth}/${persianDay}`;
  } catch (error) {
    console.error('Error formatting date:', error);
    return jalaliDate;
  }
}

/**
 * تبدیل اعداد انگلیسی به فارسی
 */
export function toPersianNumbers(str: string): string {
  const persianDigits = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
  return str.replace(/\d/g, (digit) => persianDigits[parseInt(digit)]);
}

/**
 * تبدیل اعداد فارسی به انگلیسی
 */
export function toEnglishNumbers(str: string): string {
  const persianDigits = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
  const arabicDigits = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];
  
  let result = str;
  
  persianDigits.forEach((digit, index) => {
    result = result.replace(new RegExp(digit, 'g'), index.toString());
  });
  
  arabicDigits.forEach((digit, index) => {
    result = result.replace(new RegExp(digit, 'g'), index.toString());
  });
  
  return result;
}

/**
 * دریافت نام ماه شمسی
 */
export function getJalaliMonthName(month: number): string {
  const monthNames = [
    'فروردین', 'اردیبهشت', 'خرداد', 'تیر', 'مرداد', 'شهریور',
    'مهر', 'آبان', 'آذر', 'دی', 'بهمن', 'اسفند',
  ];
  return monthNames[month - 1] || '';
}


