import type { DateLib } from "../classes/DateLib.js";
/**
 * Generates a series of 7 days, starting from the beginning of the week, to use
 * for formatting weekday names (e.g., Monday, Tuesday, etc.).
 *
 * @param dateLib The date library to use for date manipulation.
 * @param ISOWeek Whether to use ISO week numbering (weeks start on Monday).
 * @param broadcastCalendar Whether to use the broadcast calendar (weeks start
 *   on Monday, but may include adjustments for broadcast-specific rules).
 * @returns An array of 7 dates representing the weekdays.
 */
export declare function getWeekdays(dateLib: DateLib, ISOWeek?: boolean | undefined, broadcastCalendar?: boolean | undefined, today?: Date): Date[];
