<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        // Create admin user
        User::firstOrCreate(
            ['username' => 'admin'],
            [
                'password' => Hash::make('admin123'),
                'name' => 'مدیر سیستم',
                'email' => 'admin@khabar.ir',
                'role' => 'admin',
            ]
        );

        $this->command->info('Admin user created: username=admin, password=admin123');
    }
}


