<?php

namespace App\Http\Controllers;

use App\Models\Receipt;
use App\Models\Advertisement;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ReceiptController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:sanctum');
    }

    public function getByAdvertisement($advertisementId)
    {
        $advertisement = Advertisement::where('id', $advertisementId)
            ->where('user_id', Auth::id())
            ->firstOrFail();

        $printDates = \App\Models\PrintDate::where('advertisement_id', $advertisementId)
            ->get(['id', 'print_date']);

        return response()->json([
            'print_dates' => $printDates,
        ]);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'advertisement_id' => 'required|exists:advertisements,id',
            'receipt_content' => 'required|string',
            'pdf_url' => 'nullable|string|max:500',
        ]);

        $advertisement = Advertisement::where('id', $validated['advertisement_id'])
            ->where('user_id', Auth::id())
            ->firstOrFail();

        $receipt = Receipt::updateOrCreate(
            ['advertisement_id' => $validated['advertisement_id']],
            [
                'receipt_content' => $validated['receipt_content'],
                'pdf_url' => $validated['pdf_url'] ?? null,
            ]
        );

        return response()->json($receipt, 201);
    }
}


