<?php

namespace App\Helpers;

use Morilog\Jalali\Jalalian;

class JalaliHelper
{
    public static function gregorianToJalali(string $date): string
    {
        if (empty($date)) {
            return '';
        }

        try {
            $parts = explode('-', $date);
            if (count($parts) !== 3) {
                return $date;
            }

            $year = (int)$parts[0];
            $month = (int)$parts[1];
            $day = (int)$parts[2];

            $jalali = Jalalian::fromDateTime(\Carbon\Carbon::create($year, $month, $day));
            
            return sprintf('%d-%02d-%02d', $jalali->getYear(), $jalali->getMonth(), $jalali->getDay());
        } catch (\Exception $e) {
            return $date;
        }
    }

    public static function jalaliToGregorian(string $date): ?string
    {
        if (empty($date)) {
            return null;
        }

        try {
            $parts = explode('-', $date);
            if (count($parts) !== 3) {
                return null;
            }

            $year = (int)$parts[0];
            $month = (int)$parts[1];
            $day = (int)$parts[2];

            $jalali = Jalalian::fromDateTime(\Carbon\Carbon::create($year, $month, $day));
            $gregorian = $jalali->toCarbon();

            return $gregorian->format('Y-m-d');
        } catch (\Exception $e) {
            return null;
        }
    }

    public static function todayJalali(): string
    {
        $jalali = Jalalian::now();
        return sprintf('%d-%02d-%02d', $jalali->getYear(), $jalali->getMonth(), $jalali->getDay());
    }

    public static function isValidJalaliDate(string $date): bool
    {
        if (empty($date)) {
            return false;
        }

        try {
            $parts = explode('-', $date);
            if (count($parts) !== 3) {
                return false;
            }

            $year = (int)$parts[0];
            $month = (int)$parts[1];
            $day = (int)$parts[2];

            return Jalalian::isValidJalaliDate($year, $month, $day);
        } catch (\Exception $e) {
            return false;
        }
    }
}


