# دستورالعمل نصب و راه‌اندازی

## مشکلات حل شده:
1. ✅ فایل `.env` ایجاد شد
2. ✅ دایرکتوری‌های cache ایجاد شدند

## مراحل بعدی (در ترمینال):

### 1. ایجاد APP_KEY
```bash
php artisan key:generate
```

### 2. تنظیمات دیتابیس در `.env`
فایل `.env` را باز کنید و اطلاعات دیتابیس را تنظیم کنید:
```env
DB_DATABASE=khabar_ads
DB_USERNAME=root
DB_PASSWORD=your_password
```

### 3. اجرای Migrations
```bash
php artisan migrate
```

### 4. ایجاد کاربر Admin
```bash
php artisan db:seed
```

این دستور کاربر admin را با مشخصات زیر ایجاد می‌کند:
- Username: `admin`
- Password: `admin123`

### 5. تنظیم Permissions (در Linux/Mac)
```bash
chmod -R 755 storage
chmod -R 755 bootstrap/cache
```

### 6. اجرای سرور
```bash
php artisan serve
```

سپس به آدرس `http://localhost:8000` بروید.

## نکات مهم:

- اگر خطای 500 می‌گیرید، لاگ‌ها را در `storage/logs/laravel.log` بررسی کنید
- مطمئن شوید که دیتابیس MySQL در حال اجرا است
- اگر از XAMPP استفاده می‌کنید، MySQL باید در حال اجرا باشد

