# راهنمای نهایی نصب و راه‌اندازی

## ✅ کارهای انجام شده

تمام فایل‌های frontend از Node.js به Laravel تبدیل شدند:

1. ✅ API Client (`resources/js/lib/api.ts`)
2. ✅ useAuth Hook (`resources/js/_core/hooks/useAuth.ts`)
3. ✅ تمام صفحات (Login, Home, CreateAdvertisement, etc.)
4. ✅ Components و UI components کپی شدند
5. ✅ Contexts و Hooks کپی شدند
6. ✅ CSS و assets کپی شدند
7. ✅ Vite config و package.json تنظیم شدند

## 🚀 مراحل نصب

### 1. نصب Dependencies

```bash
cd laravel-app

# نصب PHP dependencies
composer install

# نصب Node.js dependencies
npm install
```

### 2. تنظیمات Environment

```bash
cp .env.example .env
php artisan key:generate
```

ویرایش `.env`:

```env
APP_NAME="Khabar Ads Manager"
APP_ENV=production
APP_DEBUG=false
APP_URL=https://your-domain.com

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=khabar_ads
DB_USERNAME=your_username
DB_PASSWORD=your_password

SESSION_DRIVER=cookie
SESSION_LIFETIME=120
```

### 3. Database Setup

```bash
php artisan migrate
php artisan db:seed
```

این دستورات:
- جداول دیتابیس را ایجاد می‌کند
- کاربر admin را ایجاد می‌کند (username: `admin`, password: `admin123`)

### 4. Build Frontend

```bash
npm run build
```

### 5. تنظیمات Production

```bash
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

### 6. تنظیمات Permissions

```bash
chmod -R 755 storage
chmod -R 755 bootstrap/cache
```

## 📁 ساختار فایل‌ها

```
laravel-app/
├── app/                    # Backend (PHP)
│   ├── Http/Controllers/  # API Controllers
│   ├── Models/            # Eloquent Models
│   └── Helpers/           # Helper functions
├── resources/
│   ├── js/                # Frontend (React)
│   │   ├── pages/        # صفحات
│   │   ├── components/   # کامپوننت‌ها
│   │   └── lib/          # Utilities
│   └── views/             # Blade templates
├── routes/
│   ├── api.php           # API routes
│   └── web.php           # Web routes
└── public/                # Public files
```

## 🔌 API Endpoints

تمام endpoints در `/api` هستند:

- `POST /api/auth/login` - ورود
- `GET /api/auth/me` - اطلاعات کاربر
- `POST /api/auth/logout` - خروج
- `GET /api/advertisements` - لیست آگهی‌ها
- `POST /api/advertisements` - ایجاد آگهی
- `GET /api/advertisements/{id}` - جزئیات آگهی
- `GET /api/receipts/advertisement/{id}` - دریافت قبض
- `GET /api/reports` - لیست گزارش‌ها
- `GET /api/users` - لیست کاربران (Admin only)

## 🎯 Frontend Structure

### API Client
- `resources/js/lib/api.ts` - تمام API calls

### Pages
- `resources/js/pages/Login.tsx` - صفحه ورود
- `resources/js/pages/Home.tsx` - صفحه اصلی
- `resources/js/pages/CreateAdvertisement.tsx` - ایجاد آگهی
- `resources/js/pages/AdvertisementDetail.tsx` - جزئیات آگهی
- `resources/js/pages/ReceiptView.tsx` - نمایش قبض
- `resources/js/pages/Reports.tsx` - گزارش‌ها
- `resources/js/pages/Users.tsx` - مدیریت کاربران (Admin)
- `resources/js/pages/ChangePassword.tsx` - تغییر رمز عبور

### Hooks
- `resources/js/_core/hooks/useAuth.ts` - Authentication hook

## 🔐 Default Admin

بعد از `php artisan db:seed`:
- **Username**: `admin`
- **Password**: `admin123`

⚠️ **مهم**: در production حتماً رمز عبور را تغییر دهید!

## 🚀 Development

```bash
# Terminal 1: Laravel
php artisan serve

# Terminal 2: Frontend
npm run dev
```

## 📦 Production Build

```bash
npm run build
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

## 🌐 Deployment

### cPanel / Shared Hosting

1. آپلود فایل‌ها به `public_html` یا دایرکتوری مربوطه
2. تنظیم `APP_ENV=production` و `APP_DEBUG=false` در `.env`
3. اجرای `php artisan migrate` و `php artisan db:seed`
4. اجرای `npm run build`
5. تنظیم permissions برای `storage` و `bootstrap/cache`

### نکات مهم

- تمام درخواست‌های API باید با `withCredentials: true` ارسال شوند
- Cookie session به صورت خودکار مدیریت می‌شود
- CORS باید برای domain frontend تنظیم شود (در صورت نیاز)

## 🐛 Troubleshooting

### خطای "Class not found"
```bash
composer dump-autoload
```

### خطای Migration
```bash
php artisan migrate:fresh
php artisan db:seed
```

### خطای Frontend Build
```bash
rm -rf node_modules
npm install
npm run build
```

### خطای 404 در Routes
```bash
php artisan route:clear
php artisan route:cache
```

## ✅ Checklist

- [x] Backend به Laravel تبدیل شد
- [x] Frontend به React + Laravel API تبدیل شد
- [x] تمام API endpoints کار می‌کنند
- [x] Authentication با Laravel Sanctum
- [x] تمام صفحات تبدیل شدند
- [x] Components و UI کپی شدند
- [x] CSS و assets کپی شدند
- [x] Vite config تنظیم شد
- [x] package.json کامل شد
- [ ] تست تمام functionality ها
- [ ] Deploy به production

## 🎊 نتیجه

پروژه با موفقیت به Laravel تبدیل شد و آماده deployment است!

برای ادامه:
1. `composer install` و `npm install`
2. تنظیم `.env`
3. `php artisan migrate` و `php artisan db:seed`
4. `npm run build`
5. تست و deploy


