# راهنمای تنظیم فایل .env

## مشکل:
فایل `.env` وجود ندارد و Laravel نیاز به `APP_KEY` دارد.

## راه حل:

### 1. ایجاد فایل `.env`
در ترمینال، در دایرکتوری `laravel-app` دستور زیر را اجرا کنید:

```bash
copy NUL .env
```

یا به صورت دستی یک فایل با نام `.env` در دایرکتوری `laravel-app` ایجاد کنید.

### 2. محتوای فایل `.env`
محتوای زیر را در فایل `.env` قرار دهید:

```env
APP_NAME="Khabar Ads Manager"
APP_ENV=local
APP_KEY=
APP_DEBUG=true
APP_URL=http://localhost:8000

LOG_CHANNEL=stack
LOG_LEVEL=debug

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=khabar_ads
DB_USERNAME=root
DB_PASSWORD=

BROADCAST_DRIVER=log
CACHE_DRIVER=file
FILESYSTEM_DISK=local
QUEUE_CONNECTION=sync
SESSION_DRIVER=cookie
SESSION_LIFETIME=120

MAIL_MAILER=smtp
MAIL_HOST=mailpit
MAIL_PORT=1025
MAIL_USERNAME=null
MAIL_PASSWORD=null
MAIL_ENCRYPTION=null
MAIL_FROM_ADDRESS="hello@example.com"
MAIL_FROM_NAME="${APP_NAME}"

VITE_APP_NAME="${APP_NAME}"
```

### 3. ایجاد APP_KEY
بعد از ایجاد فایل `.env`، در ترمینال دستور زیر را اجرا کنید:

```bash
php artisan key:generate
```

این دستور به صورت خودکار `APP_KEY` را در فایل `.env` تنظیم می‌کند.

### 4. تنظیمات دیتابیس
اطلاعات دیتابیس MySQL خود را در فایل `.env` تنظیم کنید:
- `DB_DATABASE`: نام دیتابیس
- `DB_USERNAME`: نام کاربری MySQL
- `DB_PASSWORD`: رمز عبور MySQL

### 5. اجرای Migrations
```bash
php artisan migrate
```

### 6. ایجاد کاربر Admin
```bash
php artisan db:seed
```

### 7. اجرای سرور
```bash
php artisan serve
```

سپس به آدرس `http://localhost:8000` بروید.

## اگر هنوز خطا دارید:

1. مطمئن شوید که دایرکتوری‌های زیر وجود دارند:
   - `bootstrap/cache`
   - `storage/framework/cache/data`
   - `storage/framework/sessions`
   - `storage/framework/views`

2. لاگ‌ها را بررسی کنید:
   - `storage/logs/laravel.log`

3. Cache را پاک کنید:
   ```bash
   php artisan config:clear
   php artisan cache:clear
   php artisan view:clear
   ```

