# راهنمای نصب و راه‌اندازی Laravel

## پیش‌نیازها

- PHP >= 8.2
- Composer
- MySQL >= 5.7
- Node.js و npm (برای frontend)

## نصب

### 1. نصب وابستگی‌ها

```bash
cd laravel-app
composer install
npm install
```

### 2. تنظیمات محیط

```bash
cp .env.example .env
php artisan key:generate
```

فایل `.env` را ویرایش کنید و اطلاعات دیتابیس را وارد کنید:

```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=khabar_ads
DB_USERNAME=root
DB_PASSWORD=your_password
```

### 3. اجرای Migrations

```bash
php artisan migrate
php artisan db:seed
```

این دستورات:
- جداول دیتابیس را ایجاد می‌کند
- کاربر admin را ایجاد می‌کند (username: `admin`, password: `admin123`)

### 4. Build Frontend

```bash
npm run build
```

### 5. اجرای سرور

```bash
php artisan serve
```

سرور در آدرس `http://localhost:8000` اجرا می‌شود.

## API Endpoints

### Authentication
- `POST /api/auth/login` - ورود
- `GET /api/auth/me` - اطلاعات کاربر فعلی
- `POST /api/auth/logout` - خروج

### Advertisements
- `GET /api/advertisements` - لیست آگهی‌ها
- `GET /api/advertisements/{id}` - جزئیات آگهی
- `POST /api/advertisements` - ایجاد آگهی جدید

### Receipts
- `GET /api/receipts/advertisement/{advertisementId}` - دریافت قبض
- `POST /api/receipts` - ایجاد قبض

### Reports
- `GET /api/reports` - لیست گزارش‌ها
- `GET /api/reports/date-range` - گزارش بر اساس بازه تاریخ
- `POST /api/reports` - ایجاد گزارش

### Users (Admin only)
- `GET /api/users` - لیست کاربران
- `POST /api/users` - ایجاد کاربر جدید
- `PUT /api/users/{id}` - به‌روزرسانی کاربر
- `PUT /api/users/{id}/password` - تغییر رمز عبور
- `DELETE /api/users/{id}` - حذف کاربر
- `POST /api/users/change-password` - تغییر رمز عبور خود

## Frontend

Frontend در `resources/js` قرار دارد و باید با React و Vite build شود.

برای development:
```bash
npm run dev
```

برای production:
```bash
npm run build
```

## تغییرات از نسخه Node.js

1. **Authentication**: از JWT cookies به Laravel Sanctum تغییر یافت
2. **API**: از tRPC به REST API تغییر یافت
3. **Database**: از Drizzle ORM به Eloquent ORM تغییر یافت
4. **Frontend**: React components حفظ شدند اما API calls تغییر کردند

## نکات مهم

- تمام درخواست‌های API باید با header `Accept: application/json` ارسال شوند
- برای authenticated requests، cookie session باید ارسال شود
- CORS باید برای domain frontend تنظیم شود


